function [vrbs, shocks, nvar, nstate, nshock] = defineModel()
% This function outputs the following:
% vrbs: a structure containing the position of all variables (with jump
% variables ordered before state variables)
% nvar: the total number of variables (size of vrbs)
% nstate: the number of state variables

% jump variables
vrbs.N = 1;
vrbs.R_k = 2;
vrbs.P_m = 3;
vrbs.Gamma = 4;
vrbs.c = 5;
vrbs.w_r = 6;
vrbs.pi = 7;
vrbs.y = 8;
vrbs.i = 9;
vrbs.P_k = 10;
njump = 10;

% state variables
vrbs.R = njump + 1;
vrbs.tau = njump + 2;
vrbs.c_lag = njump + 3;
vrbs.w_r_lag = njump + 4;
vrbs.pi_lag = njump + 5;
vrbs.i_lag = njump +6;
vrbs.b_m = njump + 7;
vrbs.k = njump + 8;
vrbs.gamma = njump + 9;
vrbs.theta_w = njump + 10;
vrbs.mu = njump + 11;
vrbs.g = njump + 12;
vrbs.xi = njump + 13;
vrbs.pistar = njump + 14;
vrbs.theta_p = njump + 15;
vrbs.m = njump + 16;
vrbs.tau_shock = njump + 17;
nstate = 17;

% shocks
shocks.gamma = 1;
shocks.theta_w = 2;
shocks.mu = 3;
shocks.g = 4;
shocks.xi = 5;
shocks.pistar = 6;
shocks.theta_p = 7;
shocks.m = 8;
shocks.tau = 9;
nshock = 9;

nvar = nstate + njump;

end

